<?php
require_once __DIR__ . '/partials/header.php';

use App\Core\Database;

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

$pdo = Database::getConnection();
$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $icon = trim($_POST['icon'] ?? '');
    if ($name !== '') {
        $stmt = $pdo->prepare('INSERT INTO categories (name, icon, status) VALUES (:name, :icon, "active")');
        $stmt->execute(['name' => $name, 'icon' => $icon]);
        $message = 'Category created';
    }
}

if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $stmt = $pdo->prepare('DELETE FROM categories WHERE id = :id');
    $stmt->execute(['id' => $id]);
    $message = 'Category deleted';
}

$rows = $pdo->query('SELECT * FROM categories ORDER BY name ASC')->fetchAll(PDO::FETCH_ASSOC);
?>

<h3 class="mb-3">Categories</h3>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message, ENT_QUOTES); ?></div>
<?php endif; ?>

<div class="row">
    <div class="col-md-4">
        <div class="card mb-3">
            <div class="card-body">
                <h5 class="card-title">Add Category</h5>
                <form method="post">
                    <div class="mb-3">
                        <label class="form-label">Name</label>
                        <input type="text" class="form-control" name="name" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Icon URL (optional)</label>
                        <input type="text" class="form-control" name="icon">
                    </div>
                    <button type="submit" class="btn btn-primary">Save</button>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <table class="table table-striped">
            <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Icon</th>
                <th>Status</th>
                <th></th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($rows as $row): ?>
                <tr>
                    <td><?php echo (int)$row['id']; ?></td>
                    <td><?php echo htmlspecialchars($row['name'], ENT_QUOTES); ?></td>
                    <td><?php echo htmlspecialchars($row['icon'] ?? '', ENT_QUOTES); ?></td>
                    <td><?php echo htmlspecialchars($row['status'], ENT_QUOTES); ?></td>
                    <td>
                        <a href="?delete=<?php echo (int)$row['id']; ?>"
                           onclick="return confirm('Delete this category?');"
                           class="btn btn-sm btn-outline-danger">Delete</a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/partials/footer.php'; ?>

