<?php
require_once __DIR__ . '/partials/header.php';

use App\Core\Database;

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

$pdo = Database::getConnection();

$userCount = (int)$pdo->query('SELECT COUNT(*) FROM users')->fetchColumn();
$examCount = (int)$pdo->query('SELECT COUNT(*) FROM exams')->fetchColumn();
$sessionCount = (int)$pdo->query('SELECT COUNT(*) FROM exam_sessions')->fetchColumn();
?>

<h3 class="mb-4">Dashboard</h3>
<div class="row">
    <div class="col-md-4">
        <div class="card mb-3">
            <div class="card-body">
                <h5 class="card-title">Users</h5>
                <p class="card-text display-6"><?php echo $userCount; ?></p>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card mb-3">
            <div class="card-body">
                <h5 class="card-title">Exams</h5>
                <p class="card-text display-6"><?php echo $examCount; ?></p>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card mb-3">
            <div class="card-body">
                <h5 class="card-title">Attempts</h5>
                <p class="card-text display-6"><?php echo $sessionCount; ?></p>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/partials/footer.php'; ?>

