<?php
require_once __DIR__ . '/partials/header.php';

use App\Core\Database;

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

$pdo = Database::getConnection();
$topics = $pdo->query('SELECT id, name FROM topics ORDER BY name')->fetchAll(PDO::FETCH_ASSOC);

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $topicId = (int)($_POST['topic_id'] ?? 0);
    $name = trim($_POST['name'] ?? '');
    $totalMcq = (int)($_POST['total_mcq'] ?? 50);
    $duration = (int)($_POST['duration_minutes'] ?? 60);
    $negEnabled = isset($_POST['negative_marking_enabled']) ? 1 : 0;
    $negValue = (float)($_POST['negative_mark_value'] ?? 0);

    if ($topicId > 0 && $name !== '') {
        $stmt = $pdo->prepare('
            INSERT INTO exams (topic_id, name, total_mcq, duration_minutes, negative_marking_enabled, negative_mark_value, status)
            VALUES (:topic_id, :name, :total_mcq, :duration_minutes, :neg_enabled, :neg_value, "active")
        ');
        $stmt->execute([
            'topic_id' => $topicId,
            'name' => $name,
            'total_mcq' => $totalMcq,
            'duration_minutes' => $duration,
            'neg_enabled' => $negEnabled,
            'neg_value' => $negValue,
        ]);
        $message = 'Exam created';
    }
}

if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $stmt = $pdo->prepare('DELETE FROM exams WHERE id = :id');
    $stmt->execute(['id' => $id]);
    $message = 'Exam deleted';
}

$rows = $pdo->query('
    SELECT e.id, e.name, e.total_mcq, e.duration_minutes, t.name AS topic_name
    FROM exams e
    JOIN topics t ON t.id = e.topic_id
    ORDER BY t.name, e.name
')->fetchAll(PDO::FETCH_ASSOC);
?>

<h3 class="mb-3">Exams</h3>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message, ENT_QUOTES); ?></div>
<?php endif; ?>

<div class="row">
    <div class="col-md-5">
        <div class="card mb-3">
            <div class="card-body">
                <h5 class="card-title">Add Exam</h5>
                <form method="post">
                    <div class="mb-3">
                        <label class="form-label">Topic</label>
                        <select name="topic_id" class="form-select" required>
                            <option value="">-- Select --</option>
                            <?php foreach ($topics as $top): ?>
                                <option value="<?php echo (int)$top['id']; ?>"><?php echo htmlspecialchars($top['name'], ENT_QUOTES); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Name</label>
                        <input type="text" class="form-control" name="name" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Total MCQ</label>
                        <input type="number" class="form-control" name="total_mcq" value="50" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Duration (minutes)</label>
                        <input type="number" class="form-control" name="duration_minutes" value="60" required>
                    </div>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="checkbox" name="negative_marking_enabled" id="negEnabled">
                        <label class="form-check-label" for="negEnabled">
                            Enable negative marking
                        </label>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Negative mark value</label>
                        <input type="number" step="0.01" class="form-control" name="negative_mark_value" value="0.25">
                    </div>
                    <button type="submit" class="btn btn-primary">Save</button>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-7">
        <table class="table table-striped">
            <thead>
            <tr>
                <th>ID</th>
                <th>Topic</th>
                <th>Name</th>
                <th>MCQ</th>
                <th>Duration</th>
                <th></th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($rows as $row): ?>
                <tr>
                    <td><?php echo (int)$row['id']; ?></td>
                    <td><?php echo htmlspecialchars($row['topic_name'], ENT_QUOTES); ?></td>
                    <td><?php echo htmlspecialchars($row['name'], ENT_QUOTES); ?></td>
                    <td><?php echo (int)$row['total_mcq']; ?></td>
                    <td><?php echo (int)$row['duration_minutes']; ?> min</td>
                    <td>
                        <a href="?delete=<?php echo (int)$row['id']; ?>"
                           onclick="return confirm('Delete this exam?');"
                           class="btn btn-sm btn-outline-danger">Delete</a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/partials/footer.php'; ?>

