<?php
require_once __DIR__ . '/partials/header.php';

use App\Models\User;

if (isset($_SESSION['admin_id'])) {
    header('Location: dashboard.php');
    exit;
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $mobile = trim($_POST['mobile'] ?? '');
    $password = $_POST['password'] ?? '';

    $user = User::findByMobile($mobile);
    if ($user && $user->verifyPassword($password) && $user->role === 'admin') {
        $_SESSION['admin_id'] = $user->id;
        header('Location: dashboard.php');
        exit;
    } else {
        $error = 'Invalid admin credentials';
    }
}
?>

<div class="row justify-content-center">
    <div class="col-md-4">
        <h3 class="mb-3">Admin Login</h3>
        <?php if ($error): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($error, ENT_QUOTES); ?></div>
        <?php endif; ?>
        <form method="post">
            <div class="mb-3">
                <label class="form-label">Mobile</label>
                <input type="text" class="form-control" name="mobile" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Password</label>
                <input type="password" class="form-control" name="password" required>
            </div>
            <button type="submit" class="btn btn-primary w-100">Login</button>
        </form>
    </div>
</div>

<?php require_once __DIR__ . '/partials/footer.php'; ?>

