<?php
session_start();

require_once __DIR__ . '/../../config/config.php';

spl_autoload_register(function ($class) {
    $prefix = 'App\\';
    $baseDir = __DIR__ . '/../../src/';
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }
    $relativeClass = substr($class, $len);
    $file = $baseDir . str_replace('\\', '/', $relativeClass) . '.php';
    if (file_exists($file)) {
        require $file;
    }
});

?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Exam For Student - Admin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-light bg-light mb-4">
    <div class="container-fluid">
        <a class="navbar-brand" href="dashboard.php">Exam Admin</a>
        <div class="collapse navbar-collapse">
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                <li class="nav-item"><a class="nav-link" href="categories.php">Categories</a></li>
                <li class="nav-item"><a class="nav-link" href="classes.php">Classes</a></li>
                <li class="nav-item"><a class="nav-link" href="subjects.php">Subjects</a></li>
                <li class="nav-item"><a class="nav-link" href="topics.php">Topics</a></li>
                <li class="nav-item"><a class="nav-link" href="questions.php">Questions</a></li>
                <li class="nav-item"><a class="nav-link" href="exams.php">Exams</a></li>
                <li class="nav-item"><a class="nav-link" href="results.php">Results</a></li>
            </ul>
            <span class="navbar-text">
                <?php if (isset($_SESSION['admin_id'])): ?>
                    <a href="logout.php" class="btn btn-outline-danger btn-sm">Logout</a>
                <?php endif; ?>
            </span>
        </div>
    </div>
</nav>
<div class="container">

