<?php
require_once __DIR__ . '/partials/header.php';

use App\Core\Database;

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

$pdo = Database::getConnection();
$topics = $pdo->query('SELECT id, name FROM topics ORDER BY name')->fetchAll(PDO::FETCH_ASSOC);

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $topicId = (int)($_POST['topic_id'] ?? 0);
    $question = trim($_POST['question'] ?? '');
    $optionA = trim($_POST['option_a'] ?? '');
    $optionB = trim($_POST['option_b'] ?? '');
    $optionC = trim($_POST['option_c'] ?? '');
    $optionD = trim($_POST['option_d'] ?? '');
    $correct = $_POST['correct_option'] ?? 'A';
    $explanation = trim($_POST['explanation'] ?? '');

    if ($topicId > 0 && $question !== '' && $optionA !== '' && $optionB !== '' && $optionC !== '' && $optionD !== '') {
        $stmt = $pdo->prepare('
            INSERT INTO questions (topic_id, question_text, option_a, option_b, option_c, option_d, correct_option, explanation, status)
            VALUES (:topic_id, :question_text, :option_a, :option_b, :option_c, :option_d, :correct_option, :explanation, "active")
        ');
        $stmt->execute([
            'topic_id' => $topicId,
            'question_text' => $question,
            'option_a' => $optionA,
            'option_b' => $optionB,
            'option_c' => $optionC,
            'option_d' => $optionD,
            'correct_option' => $correct,
            'explanation' => $explanation,
        ]);
        $message = 'Question created';
    }
}

if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $stmt = $pdo->prepare('DELETE FROM questions WHERE id = :id');
    $stmt->execute(['id' => $id]);
    $message = 'Question deleted';
}

$rows = $pdo->query('
    SELECT q.id, q.question_text, q.correct_option, t.name AS topic_name
    FROM questions q
    JOIN topics t ON t.id = q.topic_id
    ORDER BY t.name, q.id DESC
    LIMIT 200
')->fetchAll(PDO::FETCH_ASSOC);
?>

<h3 class="mb-3">Questions</h3>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message, ENT_QUOTES); ?></div>
<?php endif; ?>

<div class="row">
    <div class="col-md-5">
        <div class="card mb-3">
            <div class="card-body">
                <h5 class="card-title">Add Question</h5>
                <form method="post">
                    <div class="mb-3">
                        <label class="form-label">Topic</label>
                        <select name="topic_id" class="form-select" required>
                            <option value="">-- Select --</option>
                            <?php foreach ($topics as $top): ?>
                                <option value="<?php echo (int)$top['id']; ?>"><?php echo htmlspecialchars($top['name'], ENT_QUOTES); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Question</label>
                        <textarea class="form-control" name="question" rows="2" required></textarea>
                    </div>
                    <div class="mb-2">
                        <label class="form-label">Option A</label>
                        <input type="text" class="form-control" name="option_a" required>
                    </div>
                    <div class="mb-2">
                        <label class="form-label">Option B</label>
                        <input type="text" class="form-control" name="option_b" required>
                    </div>
                    <div class="mb-2">
                        <label class="form-label">Option C</label>
                        <input type="text" class="form-control" name="option_c" required>
                    </div>
                    <div class="mb-2">
                        <label class="form-label">Option D</label>
                        <input type="text" class="form-control" name="option_d" required>
                    </div>
                    <div class="mb-2">
                        <label class="form-label">Correct Option</label>
                        <select name="correct_option" class="form-select">
                            <option value="A">A</option>
                            <option value="B">B</option>
                            <option value="C">C</option>
                            <option value="D">D</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Explanation (optional)</label>
                        <textarea class="form-control" name="explanation" rows="2"></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary">Save</button>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-7">
        <table class="table table-striped">
            <thead>
            <tr>
                <th>ID</th>
                <th>Topic</th>
                <th>Question</th>
                <th>Correct</th>
                <th></th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($rows as $row): ?>
                <tr>
                    <td><?php echo (int)$row['id']; ?></td>
                    <td><?php echo htmlspecialchars($row['topic_name'], ENT_QUOTES); ?></td>
                    <td><?php echo htmlspecialchars(mb_strimwidth($row['question_text'], 0, 60, '...'), ENT_QUOTES); ?></td>
                    <td><?php echo htmlspecialchars($row['correct_option'], ENT_QUOTES); ?></td>
                    <td>
                        <a href="?delete=<?php echo (int)$row['id']; ?>"
                           onclick="return confirm('Delete this question?');"
                           class="btn btn-sm btn-outline-danger">Delete</a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/partials/footer.php'; ?>

