<?php
require_once __DIR__ . '/partials/header.php';

use App\Core\Database;

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

$pdo = Database::getConnection();

$rows = $pdo->query('
    SELECT es.id AS session_id,
           u.username,
           e.name AS exam_name,
           es.score,
           es.start_time
    FROM exam_sessions es
    JOIN users u ON u.id = es.user_id
    JOIN exams e ON e.id = es.exam_id
    WHERE es.status = "completed"
    ORDER BY es.start_time DESC
    LIMIT 200
')->fetchAll(PDO::FETCH_ASSOC);
?>

<h3 class="mb-3">Results</h3>

<table class="table table-striped">
    <thead>
    <tr>
        <th>Session ID</th>
        <th>User</th>
        <th>Exam</th>
        <th>Score</th>
        <th>Date</th>
    </tr>
    </thead>
    <tbody>
    <?php foreach ($rows as $row): ?>
        <tr>
            <td><?php echo (int)$row['session_id']; ?></td>
            <td><?php echo htmlspecialchars($row['username'], ENT_QUOTES); ?></td>
            <td><?php echo htmlspecialchars($row['exam_name'], ENT_QUOTES); ?></td>
            <td><?php echo (float)$row['score']; ?></td>
            <td><?php echo htmlspecialchars($row['start_time'], ENT_QUOTES); ?></td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>

<?php require_once __DIR__ . '/partials/footer.php'; ?>

