<?php
require_once __DIR__ . '/partials/header.php';

use App\Core\Database;

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

$pdo = Database::getConnection();
$classes = $pdo->query('SELECT id, name FROM classes ORDER BY name')->fetchAll(PDO::FETCH_ASSOC);

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $classId = (int)($_POST['class_id'] ?? 0);
    if ($name !== '' && $classId > 0) {
        $stmt = $pdo->prepare('INSERT INTO subjects (class_id, name, status) VALUES (:cid, :name, "active")');
        $stmt->execute(['cid' => $classId, 'name' => $name]);
        $message = 'Subject created';
    }
}

if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $stmt = $pdo->prepare('DELETE FROM subjects WHERE id = :id');
    $stmt->execute(['id' => $id]);
    $message = 'Subject deleted';
}

$rows = $pdo->query('
    SELECT s.id, s.name, s.status, c.name AS class_name
    FROM subjects s
    JOIN classes c ON c.id = s.class_id
    ORDER BY c.name, s.name
')->fetchAll(PDO::FETCH_ASSOC);
?>

<h3 class="mb-3">Subjects</h3>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message, ENT_QUOTES); ?></div>
<?php endif; ?>

<div class="row">
    <div class="col-md-4">
        <div class="card mb-3">
            <div class="card-body">
                <h5 class="card-title">Add Subject</h5>
                <form method="post">
                    <div class="mb-3">
                        <label class="form-label">Class</label>
                        <select name="class_id" class="form-select" required>
                            <option value="">-- Select --</option>
                            <?php foreach ($classes as $cls): ?>
                                <option value="<?php echo (int)$cls['id']; ?>"><?php echo htmlspecialchars($cls['name'], ENT_QUOTES); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Name</label>
                        <input type="text" class="form-control" name="name" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Save</button>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <table class="table table-striped">
            <thead>
            <tr>
                <th>ID</th>
                <th>Class</th>
                <th>Name</th>
                <th>Status</th>
                <th></th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($rows as $row): ?>
                <tr>
                    <td><?php echo (int)$row['id']; ?></td>
                    <td><?php echo htmlspecialchars($row['class_name'], ENT_QUOTES); ?></td>
                    <td><?php echo htmlspecialchars($row['name'], ENT_QUOTES); ?></td>
                    <td><?php echo htmlspecialchars($row['status'], ENT_QUOTES); ?></td>
                    <td>
                        <a href="?delete=<?php echo (int)$row['id']; ?>"
                           onclick="return confirm('Delete this subject?');"
                           class="btn btn-sm btn-outline-danger">Delete</a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/partials/footer.php'; ?>

