<?php
require_once __DIR__ . '/partials/header.php';

use App\Core\Database;

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

$pdo = Database::getConnection();
$subjects = $pdo->query('SELECT id, name FROM subjects ORDER BY name')->fetchAll(PDO::FETCH_ASSOC);

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $subjectId = (int)($_POST['subject_id'] ?? 0);
    if ($name !== '' && $subjectId > 0) {
        $stmt = $pdo->prepare('INSERT INTO topics (subject_id, name, status) VALUES (:sid, :name, "active")');
        $stmt->execute(['sid' => $subjectId, 'name' => $name]);
        $message = 'Topic created';
    }
}

if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $stmt = $pdo->prepare('DELETE FROM topics WHERE id = :id');
    $stmt->execute(['id' => $id]);
    $message = 'Topic deleted';
}

$rows = $pdo->query('
    SELECT t.id, t.name, t.status, s.name AS subject_name
    FROM topics t
    JOIN subjects s ON s.id = t.subject_id
    ORDER BY s.name, t.name
')->fetchAll(PDO::FETCH_ASSOC);
?>

<h3 class="mb-3">Topics</h3>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message, ENT_QUOTES); ?></div>
<?php endif; ?>

<div class="row">
    <div class="col-md-4">
        <div class="card mb-3">
            <div class="card-body">
                <h5 class="card-title">Add Topic</h5>
                <form method="post">
                    <div class="mb-3">
                        <label class="form-label">Subject</label>
                        <select name="subject_id" class="form-select" required>
                            <option value="">-- Select --</option>
                            <?php foreach ($subjects as $sub): ?>
                                <option value="<?php echo (int)$sub['id']; ?>"><?php echo htmlspecialchars($sub['name'], ENT_QUOTES); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Name</label>
                        <input type="text" class="form-control" name="name" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Save</button>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <table class="table table-striped">
            <thead>
            <tr>
                <th>ID</th>
                <th>Subject</th>
                <th>Name</th>
                <th>Status</th>
                <th></th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($rows as $row): ?>
                <tr>
                    <td><?php echo (int)$row['id']; ?></td>
                    <td><?php echo htmlspecialchars($row['subject_name'], ENT_QUOTES); ?></td>
                    <td><?php echo htmlspecialchars($row['name'], ENT_QUOTES); ?></td>
                    <td><?php echo htmlspecialchars($row['status'], ENT_QUOTES); ?></td>
                    <td>
                        <a href="?delete=<?php echo (int)$row['id']; ?>"
                           onclick="return confirm('Delete this topic?');"
                           class="btn btn-sm btn-outline-danger">Delete</a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/partials/footer.php'; ?>

