<?php

use App\Controllers\AuthController;
use App\Controllers\CategoryController;
use App\Controllers\ExamController;
use App\Controllers\ProfileController;
use App\Core\Response;
use App\Core\Router;

require_once __DIR__ . '/../config/config.php';

spl_autoload_register(function ($class) {
    $prefix = 'App\\';
    $baseDir = __DIR__ . '/../src/';
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }
    $relativeClass = substr($class, $len);
    $file = $baseDir . str_replace('\\', '/', $relativeClass) . '.php';
    if (file_exists($file)) {
        require $file;
    }
});

// CORS
header('Access-Control-Allow-Origin: ' . CORS_ALLOWED_ORIGINS);
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

$router = new Router();

// Auth
$router->add('POST', '/api/auth/register', function () {
    (new AuthController())->register();
});
$router->add('POST', '/api/auth/login', function () {
    (new AuthController())->login();
});
$router->add('GET', '/api/auth/verify', function () {
    (new AuthController())->verify();
});
$router->add('GET', '/api/auth/me', function () {
    (new AuthController())->me();
});

// Category / hierarchy
$router->add('GET', '/api/categories', function () {
    (new CategoryController())->categories();
});
$router->add('GET', '/api/categories/{id}/classes', function ($id) {
    (new CategoryController())->classesByCategory($id);
});
$router->add('GET', '/api/classes/{id}/subjects', function ($id) {
    (new CategoryController())->subjectsByClass($id);
});
$router->add('GET', '/api/subjects/{id}/topics', function ($id) {
    (new CategoryController())->topicsBySubject($id);
});

// Exam
$router->add('POST', '/api/exams/start', function () {
    (new ExamController())->start();
});
$router->add('POST', '/api/exams/session/{id}/submit', function ($id) {
    (new ExamController())->submit($id);
});
$router->add('GET', '/api/exams/session/{id}/result', function ($id) {
    (new ExamController())->result($id);
});

// Profile
$router->add('GET', '/api/profile/history', function () {
    (new ProfileController())->history();
});

try {
    $router->dispatch($_SERVER['REQUEST_METHOD'], $_SERVER['REQUEST_URI']);
} catch (Throwable $e) {
    Response::error('Server error', 500);
}

