<?php

namespace App\Controllers;

use App\Core\Response;
use App\Models\User;
use App\Middleware\AuthMiddleware;
use App\Services\JwtService;

class AuthController
{
    public function register(): void
    {
        $input = json_decode(file_get_contents('php://input'), true) ?? [];
        $username = trim($input['username'] ?? '');
        $mobile = trim($input['mobile'] ?? '');
        $password = $input['password'] ?? '';

        if ($username === '' || $mobile === '' || $password === '') {
            Response::error('All fields are required', 422);
        }

        if (User::findByMobile($mobile)) {
            Response::error('Mobile number already registered', 409);
        }

        $user = User::create($username, $mobile, $password);

        Response::json([
            'message' => 'Registered successfully',
            'user' => $user->toArray(),
        ], 201);
    }

    public function login(): void
    {
        $input = json_decode(file_get_contents('php://input'), true) ?? [];
        $mobile = trim($input['mobile'] ?? '');
        $password = $input['password'] ?? '';

        if ($mobile === '' || $password === '') {
            Response::error('Mobile and password are required', 422);
        }

        $user = User::findByMobile($mobile);
        if (!$user || !$user->verifyPassword($password)) {
            Response::error('Invalid credentials', 401);
        }

        if ($user->status !== 'active') {
            Response::error('User is blocked', 403);
        }

        $token = JwtService::encode([
            'sub' => $user->id,
            'mobile' => $user->mobile,
            'role' => $user->role,
        ]);

        Response::json([
            'token' => $token,
            'user' => $user->toArray(),
        ]);
    }

    public function verify(): void
    {
        $payload = AuthMiddleware::getUserFromToken();
        $user = User::findById((int)$payload['sub']);
        if (!$user) {
            Response::error('User not found', 404);
        }
        Response::json(['user' => $user->toArray()]);
    }

    public function me(): void
    {
        $this->verify();
    }
}

