<?php

namespace App\Controllers;

use App\Core\Response;
use App\Middleware\AuthMiddleware;
use App\Models\Category;
use App\Models\ClassLevel;
use App\Models\Subject;
use App\Models\Topic;

class CategoryController
{
    public function categories(): void
    {
        AuthMiddleware::getUserFromToken();
        $items = Category::allActive();
        Response::json(['data' => $items]);
    }

    public function classesByCategory($categoryId): void
    {
        AuthMiddleware::getUserFromToken();
        $items = ClassLevel::byCategory((int)$categoryId);
        Response::json(['data' => $items]);
    }

    public function subjectsByClass($classId): void
    {
        AuthMiddleware::getUserFromToken();
        $items = Subject::byClass((int)$classId);
        Response::json(['data' => $items]);
    }

    public function topicsBySubject($subjectId): void
    {
        AuthMiddleware::getUserFromToken();
        $items = Topic::bySubject((int)$subjectId);
        Response::json(['data' => $items]);
    }
}

