<?php

namespace App\Core;

class Response
{
    public static function json($data, int $statusCode = 200): void
    {
        http_response_code($statusCode);
        header('Content-Type: application/json');
        echo json_encode($data);
        exit;
    }

    public static function error(string $message, int $statusCode = 400, array $errors = []): void
    {
        self::json([
            'message' => $message,
            'errors' => $errors,
        ], $statusCode);
    }
}

