<?php

namespace App\Middleware;

use App\Core\Response;
use App\Services\JwtService;

class AuthMiddleware
{
    public static function getUserFromToken(): array
    {
        $headers = function_exists('getallheaders') ? getallheaders() : [];
        $authHeader = $headers['Authorization'] ?? $headers['authorization'] ?? null;

        if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
            Response::error('Unauthorized', 401);
        }

        $token = substr($authHeader, 7);
        $payload = JwtService::decode($token);
        if ($payload === null) {
            Response::error('Invalid or expired token', 401);
        }

        return $payload;
    }
}

