<?php

namespace App\Models;

use App\Core\Database;
use PDO;

class ClassLevel
{
    public static function byCategory(int $categoryId): array
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('SELECT id, category_id, name, status FROM classes WHERE category_id = :cid AND status = "active" ORDER BY name ASC');
        $stmt->execute(['cid' => $categoryId]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}

