<?php

namespace App\Models;

use App\Core\Database;
use PDO;

class Exam
{
    public int $id;
    public int $topic_id;
    public int $total_mcq;
    public int $duration_minutes;
    public bool $negative_marking_enabled;
    public float $negative_mark_value;

    public static function defaultForTopic(int $topicId): self
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('SELECT * FROM exams WHERE topic_id = :tid AND status = "active" LIMIT 1');
        $stmt->execute(['tid' => $topicId]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            $exam = new self();
            $exam->id = 0;
            $exam->topic_id = $topicId;
            $exam->total_mcq = 50;
            $exam->duration_minutes = 60;
            $exam->negative_marking_enabled = false;
            $exam->negative_mark_value = 0.0;
            return $exam;
        }
        $exam = new self();
        $exam->id = (int)$row['id'];
        $exam->topic_id = (int)$row['topic_id'];
        $exam->total_mcq = (int)$row['total_mcq'];
        $exam->duration_minutes = (int)$row['duration_minutes'];
        $exam->negative_marking_enabled = (bool)$row['negative_marking_enabled'];
        $exam->negative_mark_value = (float)$row['negative_mark_value'];
        return $exam;
    }
}

