<?php

namespace App\Models;

use App\Core\Database;
use PDO;

class ExamSessionQuestion
{
    public static function bulkInsert(int $sessionId, array $questionIds): void
    {
        if (empty($questionIds)) {
            return;
        }
        $pdo = Database::getConnection();
        $values = [];
        $params = [];
        $index = 0;
        foreach ($questionIds as $position => $questionId) {
            $values[] = "(:sid{$index}, :qid{$index}, :pos{$index})";
            $params["sid{$index}"] = $sessionId;
            $params["qid{$index}"] = $questionId;
            $params["pos{$index}"] = $position;
            $index++;
        }
        $sql = 'INSERT INTO exam_session_questions (session_id, question_id, position_index) VALUES ' . implode(', ', $values);
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
    }
}

