<?php

namespace App\Models;

use App\Core\Database;
use PDO;

class Question
{
    public static function randomByTopicExcludingUser(int $topicId, int $userId, int $limit): array
    {
        $pdo = Database::getConnection();
        $sql = '
            SELECT q.id, q.topic_id, q.question_text, q.option_a, q.option_b, q.option_c, q.option_d
            FROM questions q
            WHERE q.topic_id = :tid
              AND q.status = "active"
              AND q.id NOT IN (
                  SELECT question_id FROM user_attempted_questions WHERE user_id = :uid
              )
            ORDER BY RAND()
            LIMIT :lim
        ';
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':tid', $topicId, PDO::PARAM_INT);
        $stmt->bindValue(':uid', $userId, PDO::PARAM_INT);
        $stmt->bindValue(':lim', $limit, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public static function randomByTopic(int $topicId, int $limit): array
    {
        $pdo = Database::getConnection();
        $sql = '
            SELECT q.id, q.topic_id, q.question_text, q.option_a, q.option_b, q.option_c, q.option_d
            FROM questions q
            WHERE q.topic_id = :tid
              AND q.status = "active"
            ORDER BY RAND()
            LIMIT :lim
        ';
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':tid', $topicId, PDO::PARAM_INT);
        $stmt->bindValue(':lim', $limit, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}

