<?php

namespace App\Models;

use App\Core\Database;
use PDO;

class Subject
{
    public static function byClass(int $classId): array
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('
            SELECT s.id, s.class_id, s.name, s.status,
                   COUNT(q.id) AS question_count
            FROM subjects s
            LEFT JOIN topics t ON t.subject_id = s.id
            LEFT JOIN questions q ON q.topic_id = t.id AND q.status = "active"
            WHERE s.class_id = :cid AND s.status = "active"
            GROUP BY s.id, s.class_id, s.name, s.status
            ORDER BY s.name ASC
        ');
        $stmt->execute(['cid' => $classId]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}

