<?php

namespace App\Models;

use App\Core\Database;
use PDO;

class Topic
{
    public static function bySubject(int $subjectId): array
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('
            SELECT t.id, t.subject_id, t.name, t.status,
                   COUNT(q.id) AS question_count
            FROM topics t
            LEFT JOIN questions q ON q.topic_id = t.id AND q.status = "active"
            WHERE t.subject_id = :sid AND t.status = "active"
            GROUP BY t.id, t.subject_id, t.name, t.status
            ORDER BY t.name ASC
        ');
        $stmt->execute(['sid' => $subjectId]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}

