<?php

namespace App\Models;

use App\Core\Database;
use PDO;

class User
{
    public int $id;
    public string $username;
    public string $mobile;
    public string $password_hash;
    public string $role;
    public string $status;

    public static function findByMobile(string $mobile): ?self
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('SELECT * FROM users WHERE mobile = :mobile LIMIT 1');
        $stmt->execute(['mobile' => $mobile]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            return null;
        }
        return self::fromRow($row);
    }

    public static function findById(int $id): ?self
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('SELECT * FROM users WHERE id = :id LIMIT 1');
        $stmt->execute(['id' => $id]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            return null;
        }
        return self::fromRow($row);
    }

    public static function create(string $username, string $mobile, string $password, string $role = 'student'): self
    {
        $pdo = Database::getConnection();
        $hash = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $pdo->prepare('INSERT INTO users (username, mobile, password_hash, role, status) VALUES (:username, :mobile, :password_hash, :role, :status)');
        $stmt->execute([
            'username' => $username,
            'mobile' => $mobile,
            'password_hash' => $hash,
            'role' => $role,
            'status' => 'active',
        ]);

        $id = (int)$pdo->lastInsertId();
        $user = new self();
        $user->id = $id;
        $user->username = $username;
        $user->mobile = $mobile;
        $user->password_hash = $hash;
        $user->role = $role;
        $user->status = 'active';
        return $user;
    }

    public function verifyPassword(string $password): bool
    {
        return password_verify($password, $this->password_hash);
    }

    public function toArray(): array
    {
        return [
            'id' => $this->id,
            'username' => $this->username,
            'mobile' => $this->mobile,
            'role' => $this->role,
        ];
    }

    private static function fromRow(array $row): self
    {
        $user = new self();
        $user->id = (int)$row['id'];
        $user->username = $row['username'];
        $user->mobile = $row['mobile'];
        $user->password_hash = $row['password_hash'];
        $user->role = $row['role'];
        $user->status = $row['status'];
        return $user;
    }
}

