<?php

namespace App\Models;

use App\Core\Database;
use PDO;

class UserAnswer
{
    public static function bulkInsert(int $sessionId, array $answers): void
    {
        $pdo = Database::getConnection();
        $pdo->beginTransaction();
        $stmt = $pdo->prepare('
            INSERT INTO user_answers (session_id, question_id, selected_option, answered_at)
            VALUES (:session_id, :question_id, :selected_option, NOW())
            ON DUPLICATE KEY UPDATE selected_option = VALUES(selected_option), answered_at = NOW()
        ');
        foreach ($answers as $answer) {
            $stmt->execute([
                'session_id' => $sessionId,
                'question_id' => $answer['question_id'],
                'selected_option' => $answer['selected_option'] ?? null,
            ]);
        }
        $pdo->commit();
    }

    public static function detailForSession(int $sessionId): array
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('
            SELECT q.question_text,
                   q.option_a,
                   q.option_b,
                   q.option_c,
                   q.option_d,
                   q.correct_option,
                   q.explanation,
                   ua.selected_option
            FROM exam_session_questions esq
            JOIN questions q ON q.id = esq.question_id
            LEFT JOIN user_answers ua ON ua.session_id = esq.session_id AND ua.question_id = esq.question_id
            WHERE esq.session_id = :sid
            ORDER BY esq.position_index ASC
        ');
        $stmt->execute(['sid' => $sessionId]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}

