<?php

namespace App\Models;

use App\Core\Database;
use PDO;

class UserAttemptedQuestion
{
    public static function markAttempted(int $userId, array $questionIds): void
    {
        if (empty($questionIds)) {
            return;
        }

        $pdo = Database::getConnection();
        $values = [];
        $params = [];
        $i = 0;
        foreach ($questionIds as $qid) {
            $values[] = "(:user_id{$i}, :question_id{$i}, NOW())";
            $params["user_id{$i}"] = $userId;
            $params["question_id{$i}"] = $qid;
            $i++;
        }

        $sql = '
            INSERT INTO user_attempted_questions (user_id, question_id, last_attempted_at)
            VALUES ' . implode(', ', $values) . '
            ON DUPLICATE KEY UPDATE last_attempted_at = VALUES(last_attempted_at)
        ';
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
    }
}

